#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_ProductType : BaseTest 
	{

		private BOL.ProductType _tstPT;


		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			this._tstPT = new BOL.ProductType();
			_tstPT.SetInitialBrokenRules("FrmBloodProductEdit", "NewBloodProduct");
		}

		
		[Test]
		public void Ctor_Pass()
		{
			this._tstPT = new BOL.ProductType();
			Assert.AreEqual(this._tstPT.ProductTypeCode,string.Empty);
			Assert.AreEqual(this._tstPT.ProductTypeText,string.Empty);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_String_Pass()
		{
			this._tstPT = new BOL.ProductType("E001");
			Assert.AreEqual("E001",this._tstPT.ProductTypeCode);
			Assert.AreEqual(null,this._tstPT.ProductTypeText);

		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_String_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
		    DataTable dt = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ProductType");
			DataRow dr = dt.Rows[0];
			BOL.ProductType pr = new BOL.ProductType(dr);
			Assert.IsNotNull( pr );
			Assert.AreEqual(dr["ProductTypeCode"].ToString(), pr.ProductTypeCode);
			Assert.AreEqual(dr["ProductTypeName"].ToString(), pr.ProductTypeText);
            Assert.AreEqual(System.Convert.ToBoolean(dr["AboRhConfirmationRequired"]), pr.AboRhConfirmationRequired);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(NullReferenceException))]
		public void Ctor_DataRow_Fail()
		{
			BOL.ProductType pr = new BOL.ProductType( (DataRow)null );
			Assert.IsNull( pr );
		}


		[Test]
		public void ProductTypeCode_Get()
		{
			string __tstPTCode = this._tstPT.ProductTypeCode;
			Assert.AreEqual(this._tstPT.ProductTypeCode,__tstPTCode);
		}
		
		[Test]
		public void ProductTypeCode_Set()
		{
			this._tstPT.ProductTypeCode = "E999";
			Assert.AreEqual(_tstPT.IsRuleBroken("ProductTypeCode"), false);
		}
		
		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void ProductTypeCode_Set_InvalidFormat()
		{
			string __tstPTCode = string.Empty.PadRight(4,'X');
			this._tstPT.ProductTypeCode = __tstPTCode;
		}
		
		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void ProductTypeCode_Set_LengthFail()
		{
			string __tstPTCode = "E9999";
			this._tstPT.ProductTypeCode = __tstPTCode;
		}
		
		[Test]
		public void ProductTypeName_Get()
		{
			string __tstPTName = this._tstPT.ProductTypeText;
			Assert.AreEqual(this._tstPT.ProductTypeText,__tstPTName);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ProductTypeName_Set()
		{
		}

        [Test]
        public void AboRhConfirmationRequired_Get()
        {
            bool _tstValue = this._tstPT.AboRhConfirmationRequired;
            Assert.AreEqual(this._tstPT.AboRhConfirmationRequired, _tstValue);
        }

        [Test]
        [Ignore(StandardIgnoreReasons.NoFailureConditions)]
        public void AboRhConfirmationRequired_Set()
        {
        }

		[Test]
		public void Clear_Pass()
		{
			this._tstPT.ProductTypeCode = "E999";
			this._tstPT.ProductTypeText = string.Empty.PadRight(45,'X');
			this._tstPT.Clear();
			Assert.AreEqual(this._tstPT.ProductTypeCode,string.Empty);
			Assert.AreEqual(this._tstPT.ProductTypeText,string.Empty);
            Assert.AreEqual(this._tstPT.AboRhConfirmationRequired, false);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Clear_Fail()
		{
		}

		[Test]
		public void GetProductTypeLookupList_Pass()
		{
			DataTable _dt = BOL.ProductType.GetProductTypeLookupList();
			Assert.IsTrue(_dt.Rows.Count>0,"Product Type List not returned");
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductTypeLookupList_Fail()
		{
		}

		[Test]
		public void BloodProductModifications_Get()
		{
			BOL.BloodProductModifications bpms = _tstPT.BloodProductModifications;
			Assert.AreEqual(_tstPT.BloodProductModifications,bpms);

		}

		[Test]
		public void BloodProductModifications_Set()
		{
			BOL.BloodProductModifications bpms = new BOL.BloodProductModifications();
			_tstPT.BloodProductModifications = bpms;
			Assert.AreEqual(bpms,_tstPT.BloodProductModifications);

		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr1 = new DataTable().NewRow();

			DataRow dr2 = this._tstPT.LoadDataRowFromThis(dr1);

			Assert.AreEqual(dr1, dr2);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}


		[Test]
		public void IsTypeFrozen_Pass()
		{
			Assert.IsNotNull(this._tstPT.IsTypeFrozen);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsTypeFrozen_Fail()
		{
		}

		[Test]
		public void ProductTypeEnum_Pass()
		{
			BOL.ProductType pt=new ProductType(Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.ApheresisCryoprecipitate));
			Assert.IsNotNull(pt.ProductTypeEnum);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ProductTypeEnum_Fail()
		{
		}

	}
}
#endif

